<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?id=34&alias=linee-guida-per-l%2527uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    
    $cerca            = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $parametriRicerca = $cerca!="" ? array("titolo"=>$cerca) : array();
    $parametri = array("tabella"=>"geec_gruppi", "elementiPerPagina"=>30,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneGruppi.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione di Geecom Admin - gestione gruppi</title>

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
</head>

<body>
   
    <header>
        <?php  
            include "include/barraSuperiore.php";

            include "include/header.php";

            include "include/barraMenu.php";
        ?>
    </header>
    
    <!-- Modal box creazione amministratore-->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title" id="myModalLabel">Crea un nuovo utente</h4>
          </div>
          <div class="modal-body">
            <form class="form-horizontal" role="form" name="modalForm" action="utenti/creaUtente.php" method="post">
          <div class="form-group">
            <label for="campoTesto1" class="col-sm-3 control-label">Nome</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="campoTesto1" name="nome" placeholder="Nome">
            </div>
          </div>
          
          <div class="form-group">
            <label for="campoTesto1" class="col-sm-3 control-label">Cognome</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="campoTesto1" name="cognome" placeholder="Cognome">
            </div>
          </div>
                
          <div class="form-group">
            <label for="inputEmail3" class="col-sm-3 control-label">Email</label>
            <div class="col-sm-9">
              <input type="email" class="form-control" id="inputEmail3" name="email" placeholder="Email">
            </div>
          </div>
          
          <div class="form-group">
            <label for="inputEmail3" class="col-sm-3 control-label">Password</label>
            <div class="col-sm-9">
              <input type="email" class="form-control" name="password" placeholder="Password">
            </div>
          </div>
          
          <input type="text" class="hidden" name="idUtente" value="0">
          
          <div class="form-group">
            <label for="selectEsempio1"class="col-sm-3 control-label">Ruolo</label>
            <div class="col-sm-4">
            <select class="form-control" name="ruolo">
                <option value="articolista">articolista</option>
                <option value="amministratore">amministratore</option>
                <option value="super admin">super admin</option>
            </select>
            </div>
           </div>
        </form>
          </div>
          
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Chiudi</button>
            <button type="button" class="btn btn-primary" onclick={document.modalForm.submit();}>Crea utente</button>
          </div>
        </div><!-- /.modal-content -->
      </div><!-- /.modal-dialog -->
    </div><!-- /.Modal box-->
    
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <?php
                    if(isset($_GET["status"])) {
                        if($_GET["status"]==1) {
                                echo"<p class=\"alert alert-success\">Utente creato</p>";
                        }
                        else if($_GET["status"]==2) {
                                echo"<p class=\"alert alert-success\">Utente modificato</p>";
                        }
                        else if($_GET["status"]==4) {
                                echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                        }
                        else if($_GET["status"]==400) {
                                echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                        }
                        else { //status = 5
                                echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                        }
                    }
                ?>

                <div class="container-fluid">
                    <div class="row">
                        <!-- Colonna principale -->
                        <div class="col py-4">
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-header">
                                    <span class="card-title mr-2"> Elenco gruppi</span>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-4 col-xl-3">
                                            <form>
                                                <div class="mb-4 add-box">
                                                    <h6 class="mb-3"> Crea un nuovo gruppo </h6>
                                                    <div class="options-box">
                                                        <div class="form-group">
                                                            <label for="nome-voce-menu-1">Nome</label>
                                                            <input type="text" class="form-control" id="nome" placeholder="Nome">
                                                        </div>
                                                        <div class="form-group" id="divLinkMenu">
                                                            <label for="nome-voce-menu-3">Descrizione</label>
                                                            <textarea rows=5 class="form-control" id="descrizione" placeholder="Descrizione" ></textarea>
                                                        </div>
                                                        <button type="button" class="btn btn-primary float-right" value="Crea"  onclick="creaGruppo()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="col-sm-8 col-xl-9 mb-4 gerarchia-menu" >
                                            <div id="elencoGruppi" class="row">  
                                            <?php 
                                                $ris = $ricerca->eseguiRicerca(1);
                                                while($voceMenu = $ris->fetch_assoc()) {
                                                    $numeroUtenti = $geecomDb->contaRigheTabella("geec_gruppiUtenti",array("idGruppo"=>$voceMenu["id"]));
                                                    echo"<div id=\"gruppo{$voceMenu["id"]}\" class=\"col-sm-6 col-lg-4\">
                                                            <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                                                                <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                                                    <p class=\"mb-0\"><em><strong>{$voceMenu["nome"]}</strong></em>  </p>
                                                                    <small><em>$numeroUtenti utenti</em></small>
                                                                </div>
                                                                <div class=\"azioni d-flex align-items-center justify-content-end\">
                                                                    <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                                                        <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Visualizza utenti\" onclick=\"location.href='elencoUtenti.php?idGruppo={$voceMenu["id"]}';\"><i class=\"fas fa-users\"></i></button>
                                                                        <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaGruppo({$voceMenu["id"]},'{$voceMenu["nome"]}','{$voceMenu["descrizione"]}')\"><i class=\"fas fa-edit\"></i></button>
                                                                        <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaGruppo({$voceMenu["id"]},'{$voceMenu["nome"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                                                                    </div>
                                                               </div>
                                                            </div>
                                                        </div>";
                                                }
                                            ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /Colonna principale -->
                    </div>
		</div>
            </div>
        </div>
    </main>
    
    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
                
        include "include/modal/modalMenuComponenti.php";
        
        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>

    <div class="modal fade" id="modalModificaGruppo" tabindex="-1" role="dialog" aria-labelledby="modifica-gruppo" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                      <h5 class="modal-title" id="exampleModalLongTitle">Modifica gruppo</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                      </button>
                </div>
                <div class="modal-body">
                      <form>
                            <input type="text" class="d-none" id="idGruppoDaModificare" name="id">
                            
                            <div class="form-group">
                                <label for="nome-voce-menu-1">Nome</label>
                                <input type="text" class="form-control" id="nomeGruppoDaModificare" name="nome" placeholder="Nome">
                            </div>

                            <div class="form-group">
                                <label for="nome-voce-menu-2">Descrizione</label>
                                <textarea rows="5" class="form-control" id="descrizioneGruppoDaModificare" placeholder="Descrizione"></textarea>
                            </div>
                      </form>
                </div>
                <div class="modal-footer">
                      <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                      <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaGruppo()"><i class="fas fa-check"></i> Salva</button>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="modalEliminaElemento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare il gruppo?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-row justify-content-center">
                        <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                        <div class="align-self-center text-center">
                            <span class="align-self-center text-primary"><em id="nomeGruppoDaEliminare"></em></span>
                            <div id="tipoElementoDaEliminare"></div>
                        </div>
                    </div>
                    <input type="text" class="d-none" id="gruppoDaEliminare">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneVoceMenu()"><i class="fas fa-check"></i> Elimina</button>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">

            function modificaAmministratore(idUtente,nome,cognome,email,ruolo) {
                    $('#myModalLabel2').text("Modifica i dati dell'utente "+nome);
                    document.getElementById("idUtente").value = idUtente;
                    document.getElementById("campoTesto2").value = nome;
                    document.getElementById("campoTesto3").value = cognome;
                    document.getElementById("inputEmail2").value = email;
                    document.getElementById("ruoloAmministratore").value = ruolo;
                    $('#myModal2').modal('show');
            }

            function eliminaAmministratore(idUtente,nome) {
                    $('#myModalLabel3').text("Eliminare l'utente "+nome+"?");
                    document.getElementById("utenteDaEliminare").value = idUtente;
                    $('#myModal3').modal('show');
            }
            
            function creaGruppo() {
                var nomeGruppo  = $('#nome').val();
                var descrizione = $('#descrizione').val();
                
                if(nomeGruppo.length>0) {
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerGruppi.php",
                        data:{
                            operazione:"crea",
                            id:0,
                            nome:nomeGruppo,
                            descrizione:descrizione
                        },
                        success:function(codiceHtml) {
                            if(codiceHtml=="Errore: esiste già un gruppo con questo nome") {
                                alert("Errore: esiste già un gruppo con questo nome")
                            }
                            else {
                                var elencoGruppi = document.getElementById("elencoGruppi");
                                elencoGruppi.innerHTML = elencoGruppi.innerHTML + codiceHtml;
                            }
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }
                else {
                    alert("Inserisci il nome del gruppo");
                }
            }
            
            function eliminaGruppo(id,nomeElemento) {
                $('#gruppoDaEliminare').val(id);
                $('#nomeGruppoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneVoceMenu() {
                var id = $('#gruppoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerGruppi.php",
                    data:{
                        operazione:"elimina",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("gruppo"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function modificaGruppo(id,nome,descrizione) {
                $('#idGruppoDaModificare').val(id);
                $('#nomeGruppoDaModificare').val(nome);
                $('#descrizioneGruppoDaModificare').val(descrizione);
                $('#modalModificaGruppo').modal('show');
            }
            
            function eseguiModificaGruppo() {
                var id    = $('#idGruppoDaModificare').val();
                var nome  = $('#nomeGruppoDaModificare').val();
                var descrizione  = $('#descrizioneGruppoDaModificare').val();
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerGruppi.php",
                    data:{
                        operazione:"modifica",
                        id:id,
                        nome:nome,
                        descrizione:descrizione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#modalModificaGruppo').modal('hide');
                            aggiornaElencoGruppi();
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaElencoGruppi() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerGruppi.php",
                    data:{
                        operazione:"stampaGruppi",
                        id:0
                    },
                    success:function(result) {
                        document.getElementById("elencoGruppi").innerHTML = result;
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
    </script>
</body>
</html>
